//
//  GLViewController.h
//  OpenGLESwoIB
//
//  Created by 渡部 心 on 2013/04/18.
//  Copyright (c) 2013年 渡部 心. All rights reserved.
//

#import <UIKit/UIKit.h>
@class EAGLView;
@class Shader;
@class BufferObject;
@class VAOSet;
@class MatrixStack;

@interface GLViewController : UIViewController {
    EAGLView* _glView;
    EAGLContext* _glContext;
    
    Shader* _simpleShader;
    BufferObject* _vertBO;
    BufferObject* _IndexBO;
    VAOSet* _VAO;
    
    MatrixStack* _projectionMatrix;
    MatrixStack* _modelviewMatrix;
    float _rotateXYZ[3];
    
    BOOL _animating;
    NSInteger _animationFrameInterval;
    CADisplayLink* _displayLink;
}

@end
