//
//  GLViewController.m
//  OpenGLESwoIB
//
//  Created by 渡部 心 on 2013/04/18.
//  Copyright (c) 2013年 渡部 心. All rights reserved.
//

#import "GLViewController.h"
#import "EAGLView.h"
#import "OpenGLClasses.h"
#import <QuartzCore/QuartzCore.h>

@interface GLViewController ()

@end

@implementation GLViewController

- (id)init
{
    self = [super init];
    if (self) {
        // Custom initialization
    }
    return self;
}

- (void)loadView {
    _glContext = [[EAGLContext alloc] initWithAPI:kEAGLRenderingAPIOpenGLES2];
    _glView = [[EAGLView alloc] initWithFrame:[[UIScreen mainScreen] bounds]];
    _glView.contentScaleFactor = [UIScreen mainScreen].scale;//Retina対応。
    self.view = _glView;
    
    [_glView setContext:_glContext];
    [_glView setFramebuffer];
    
    glEnable(GL_DEPTH_TEST);
    glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
    
    _simpleShader = [[Shader alloc] initWithShaderPath_VS:@"Shaders/SimplestShader.vsh" FS:@"Shaders/SimplestShader.fsh"];
    {
        [_simpleShader validateUniform:@"projectionMatrix"];
        [_simpleShader validateUniform:@"modelviewMatrix"];
        
        [_simpleShader validateAttribute:@"positionVSin"];
        [_simpleShader validateAttribute:@"colorVSin"];
    }
    
    //    6 ------ 7
    //   /|       /|
    //  2 ------ 3 |
    //  | |      | |
    //  | 4 -----| 5
    //  |/       |/
    //  0 ------ 1
    float vertData[] = {
        -1.0f, -1.0f, -1.0f, 0.5f, 0.5f, 0.5f, 
         1.0f, -1.0f, -1.0f, 1.0f, 0.5f, 0.5f, 
        -1.0f,  1.0f, -1.0f, 0.5f, 1.0f, 0.5f, 
         1.0f,  1.0f, -1.0f, 1.0f, 1.0f, 0.5f, 
        
        -1.0f, -1.0f,  1.0f, 0.5f, 0.5f, 1.0f, 
         1.0f, -1.0f,  1.0f, 1.0f, 0.5f, 1.0f, 
        -1.0f,  1.0f,  1.0f, 0.5f, 1.0f, 1.0f, 
         1.0f,  1.0f,  1.0f, 1.0f, 1.0f, 1.0f, 
    };
    unsigned short indexData[] = {
        0, 1, 3, 
        0, 3, 2, 
        5, 4, 6, 
        5, 6, 7, 
        1, 5, 7, 
        1, 7, 3, 
        4, 0, 2, 
        4, 2, 6, 
        2, 3, 7, 
        2, 7, 6, 
        1, 0, 4, 
        1, 4, 5, 
    };
    
    _vertBO = [[BufferObject alloc] initWithData:vertData size:sizeof(float) length:48 
                                          Target:BufferTarget_ArrayBuffer Usage:BufferUsageHint_StaticDraw];
    _IndexBO = [[BufferObject alloc] initWithData:indexData size:sizeof(unsigned short) length:36 
                                           Target:BufferTarget_ElementArrayBuffer Usage:BufferUsageHint_StaticDraw];
    
    _VAO = [[VAOSet alloc] init];
    [_VAO bindVertexArray];
    {
        [_simpleShader enableVertexAttribArray:@"positionVSin"];
        [_simpleShader enableVertexAttribArray:@"colorVSin"];
        [_vertBO bindBuffer];
        [_simpleShader vertexAttribPointer:@"positionVSin" numComps:3 type:GL_FLOAT normalized:GL_FALSE 
                                    stride:6 * sizeof(float) pointer:(GLvoid*)0];
        [_simpleShader vertexAttribPointer:@"colorVSin" numComps:3 type:GL_FLOAT normalized:GL_FALSE 
                                    stride:6 * sizeof(float) pointer:(GLvoid*)(3 * sizeof(float))];
        [_IndexBO bindBuffer];   
    }
    
    _projectionMatrix = [[MatrixStack alloc] init];
    CGSize size = self.view.frame.size;
    float aspect = size.width / size.height;
    glcPerspectiveMatrix(-aspect, aspect, -1, 1, 1.0f, 100.0f, _projectionMatrix.current);
    glUniformMatrix4fv([_simpleShader uniform:@"projectionMatrix"], 1, GL_FALSE, _projectionMatrix.current);
    
    _modelviewMatrix = [[MatrixStack alloc] init];
    glcLookAt(0, 0, 5, 0, 0, 0, 0, 1, 0, _modelviewMatrix.current);
    
    _rotateXYZ[0] = 0.0f;
    _rotateXYZ[1] = 0.0f;
    _rotateXYZ[2] = 0.0f;
    
    glcPrintError();
    
    _animating = NO;
    _animationFrameInterval = 1;
    _displayLink = nil;
}

- (void)viewDidLoad
{
    [super viewDidLoad];
	// Do any additional setup after loading the view.
}

- (void)didReceiveMemoryWarning
{
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

- (void)viewDidAppear:(BOOL)animated {
    [super viewDidAppear:animated];
    [self startAnimation];
}

- (void)viewWillDisappear:(BOOL)animated {
    [super viewWillDisappear:animated];
    [self stopAnimation];
}

- (void)startAnimation
{
    if (!_animating) {
        CADisplayLink* aDisplayLink = [[UIScreen mainScreen] displayLinkWithTarget:self selector:@selector(drawFrame)];
        [aDisplayLink setFrameInterval:_animationFrameInterval];
        [aDisplayLink addToRunLoop:[NSRunLoop currentRunLoop] forMode:NSDefaultRunLoopMode];
        _displayLink = aDisplayLink;
        
        _animating = TRUE;
        [_glView becomeFirstResponder];
    }
}

- (void)stopAnimation
{
    if (_animating) {
        [_displayLink invalidate];
        _displayLink = nil;
        _animating = NO;
        
        [_glView resignFirstResponder];
    }
}

- (void)drawFrame {
    [_glView setFramebuffer];
    glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
    
    [_modelviewMatrix push];
    
    float rotation[16];
    glcRotateMatrix(_rotateXYZ[2] * DEG2RAD, 0, 0, 1, rotation);
    [_modelviewMatrix postMult:rotation];
    glcRotateMatrix(_rotateXYZ[1] * DEG2RAD, 0, 1, 0, rotation);
    [_modelviewMatrix postMult:rotation];
    glcRotateMatrix(_rotateXYZ[0] * DEG2RAD, 1, 0, 0, rotation);
    [_modelviewMatrix postMult:rotation];
    
    _rotateXYZ[0] = fmodf(_rotateXYZ[0] + 0.5f, 360.0f);
    _rotateXYZ[1] = fmodf(_rotateXYZ[1] + 1.0f, 360.0f);
    _rotateXYZ[2] = fmodf(_rotateXYZ[2] + 1.5f, 360.0f);
    
    glUniformMatrix4fv([_simpleShader uniform:@"modelviewMatrix"], 1, GL_FALSE, _modelviewMatrix.current);
    
    [_VAO bindVertexArray];
    glDrawElements(GL_TRIANGLES, 36, GL_UNSIGNED_SHORT, NULL);
    
    [_modelviewMatrix pop];
    
    [_glView presentFramebuffer];
}

@end
