//
//  OpenGLClasses.h
//  OpenGLESwoIB
//
//  Created by 渡部 心 on 2013/04/18.
//  Copyright (c) 2013年 渡部 心. All rights reserved.
//

#import <Foundation/Foundation.h>

#ifndef RAD2DEG
#define RAD2DEG 57.295779513082320876798154814105170332405472466564
#endif
#ifndef DEG2RAD
#define DEG2RAD 0.017453292519943295769236907684886127134428718885417
#endif

void glcIdentityMatrix(float* matrix);

void glcOrthogonalMatrix(float left, float right, float bottom, float top, float near, float far, float* matrix);
void glcPerspectiveMatrix(float left, float right, float bottom, float top, float near, float far, float* matrix);

void glcLookAt(float ex, float ey, float ez, float tx, float ty, float tz, float ux, float uy, float uz, float* matrix);

void glcScaleMatrix(float sx, float sy, float sz, float* matrix);
void glcRotateMatrix(float angle, float rx, float ry, float rz, float* matrix);
void glcTranslateMatrix(float tx, float ty, float tz, float* matrix);

void glcCopyMatrix(const float* m0, float* matrix);
void glcTransposeMatrixSelf(float* matrix);
void glcMultiplyMatrix(const float* m0, const float* m1, float* matrix);

void glcPrintMatrix(const float* matrix);
void glcPrintError();

//------------------------------------------------------------------------------------------------

@interface MatrixStack : NSObject {
    GLfloat* _memoryPool;
    GLfloat* _current;
    int _counter;
    unsigned int _depth;
}

@property (nonatomic) GLfloat* current;
@property (nonatomic, readonly) int counter;

- (id)initWithDepth:(unsigned int)depth;

- (void)push;
- (void)pop;
- (void)resetLevel;
- (void)preMult:(GLfloat*)matrix;
- (void)postMult:(GLfloat*)matrix;

@end

//------------------------------------------------------------------------------------------------

typedef enum {
    BufferTarget_ArrayBuffer = GL_ARRAY_BUFFER,
    BufferTarget_ElementArrayBuffer = GL_ELEMENT_ARRAY_BUFFER,
} BufferTarget;

typedef enum {
    BufferUsageHint_StreamDraw = GL_STREAM_DRAW,
    BufferUsageHint_StaticDraw = GL_STATIC_DRAW,
    BufferUsageHint_DynamicDraw = GL_DYNAMIC_DRAW,
} BufferUsageHint;

typedef enum {
    Attachment_Color0 = GL_COLOR_ATTACHMENT0,
    Attachment_Depth = GL_DEPTH_ATTACHMENT,
    Attachment_Stencil = GL_STENCIL_ATTACHMENT,
} Attachment;

typedef enum {
    PixelFormat_StencilIndex = GL_STENCIL_INDEX,
    PixelFormat_DepthComponent = GL_DEPTH_COMPONENT,
    PixelFormat_RGB = GL_RGB,
    PixelFormat_RGBA = GL_RGBA,
    PixelFormat_BGRA = GL_BGRA,
} PixelFormat;

typedef enum {
    PixelType_UnsignedByte = GL_UNSIGNED_BYTE,
    PixelType_Byte = GL_BYTE,
    PixelType_UnsignedShort = GL_UNSIGNED_SHORT,
    PixelType_Short = GL_SHORT,
    PixelType_UnsignedInt = GL_UNSIGNED_INT,
    PixelType_Int = GL_INT,
    PixelType_Float = GL_FLOAT,
    
    PixelType_UnsignedShort_5_6_5 = GL_UNSIGNED_SHORT_5_6_5,
    PixelType_UnsignedShort_4_4_4_4 = GL_UNSIGNED_SHORT_4_4_4_4,
    PixelType_UnsignedShort_4_4_4_4_Rev = GL_UNSIGNED_SHORT_4_4_4_4_REV,
    PixelType_UnsignedShort_5_5_5_1 = GL_UNSIGNED_SHORT_5_5_5_1,
    PixelType_UnsignedShort_1_5_5_5_Rev = GL_UNSIGNED_SHORT_1_5_5_5_REV,
} PixelType;


typedef enum {
    BaseInternalFormat_DepthComponent = GL_DEPTH_COMPONENT,
    BaseInternalFormat_RGB = GL_RGB,
    BaseInternalFormat_RGBA = GL_RGBA,
} BaseInternalFormat;

typedef enum {
    SizedInternalFormat_DepthComponent16 = GL_DEPTH_COMPONENT16,
    
    SizedInternalFormat_RGBA4 = GL_RGBA4,
    SizedInternalFormat_RGB5_A1 = GL_RGB5_A1,
} SizedInternalFormat;

//------------------------------------------------------------------------------------------------

@interface Shader : NSObject {
@private
    GLuint _programID;
    GLuint _VSID;
    GLuint _FSID;
    NSString* _VSPath;
    NSString* _FSPath;
    NSString* _VSSource;
    NSString* _FSSource;
    NSMutableDictionary* _attributes;
    NSMutableDictionary* _uniforms;
    BOOL _compiled;
}

@property(nonatomic, readonly) GLuint programID;
@property(nonatomic, readonly) GLuint VSID;
@property(nonatomic, readonly) GLuint FSID;
@property(nonatomic, readonly) NSString* VSPath;
@property(nonatomic, readonly) NSString* FSPath;
@property(nonatomic, readonly) NSString* VSSource;
@property(nonatomic, readonly) NSString* FSSource;
@property(nonatomic, readonly) BOOL compiled;

- (id)initWithShaderPath_VS:(NSString*)vspath FS:(NSString*)fspath;
- (BOOL)compile;
- (void)validate;
- (void)deleteShader;

- (void)useProgram;
- (void)validateAttribute:(NSString*)attribute;
- (void)validateUniform:(NSString*)uniform;
- (GLuint)attribute:(NSString*)attribute;
- (GLuint)uniform:(NSString*)uniform;
- (void)enableVertexAttribArray:(NSString*)attribute;
- (void)vertexAttribPointer:(NSString*)attribute numComps:(GLint)nc type:(GLenum)t 
                 normalized:(GLboolean)norm stride:(GLsizei)s pointer:(GLvoid*)ptr;
@end

//------------------------------------------------------------------------------------------------

@interface BufferObject : NSObject {
@private
    GLuint _ID;
    BufferTarget _target;
    BufferUsageHint _usage;
    GLsizei _unitSize;
    GLsizei _length;
}

@property(nonatomic, readonly) GLuint ID;
@property(nonatomic, readonly) BufferTarget target;
@property(nonatomic, readonly) BufferUsageHint usage;
@property(nonatomic, readonly) GLsizei unitSize;
@property(nonatomic, readonly) GLsizei length;

- (id)initWithData:(void*)data size:(int)size length:(int)length Target:(BufferTarget)target Usage:(BufferUsageHint)usage;
- (void)bindBuffer;
- (void)unbindBuffer;
- (void)deleteBuffer;

@end

//------------------------------------------------------------------------------------------------


@interface VAOSet : NSObject {
@private
    GLuint _ID;
}

@property(nonatomic, readonly) GLuint ID;

- (id)init;
- (void)bindVertexArray;
- (void)deleteVertexArray;

@end

//------------------------------------------------------------------------------------------------

@interface FBO : NSObject {
    GLuint _FBOID;
    GLuint _colorBufferID;
    GLuint _depthBufferID;
    BOOL _colorIsRB;
    BOOL _depthIsRB;
}

@property (nonatomic, readonly) GLuint ID;
@property (nonatomic, readonly) GLuint colorBufferID;
@property (nonatomic, readonly) GLuint depthBufferID;
@property (nonatomic, readonly) BOOL colorIsRB;
@property (nonatomic, readonly) BOOL depthIsRB;

- (id)initWithSizeW:(int)w H:(int)h colorRB:(BOOL)colorRB depthRB:(BOOL)depthRB
colorInternalFormat:(SizedInternalFormat)colorInternalFormat
depthInternalFormat:(SizedInternalFormat)depthInternalFormat;

- (BOOL)checkFrameBufferStatus;

@end

//------------------------------------------------------------------------------------------------
